<!DOCTYPE html>
<html lang="zxx">
<head>

    <!-- Metas -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
  
   <title>  <?php echo e(@$branch->translations->where('lang_id',$active_lang->id)->first()->title); ?></title>

    <meta name='description' itemprop='description' content='<?php echo e(@$branch->translations->where('lang_id',$active_lang->id)->first()->content); ?>' />

    <meta name='keywords' content='<?php echo e(@$branch->translations->where('lang_id',$active_lang->id)->first()->content); ?>' />

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset($branch->logo)); ?>" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Cairo:200,300,400,600,700,900&display=swap" rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css?family=Tajawal:200,300,400,500,700,800,900&display=swap&subset=arabic,cyrillic"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=El+Messiri:300,400,700,600" rel="stylesheet">

    <!-- Plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/plugins.css" />
    <?php if(LaravelLocalization::getCurrentLocale() == 'en'): ?>
    <!-- bootstrap-rtl.min -->
        <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/bootstrap-ltr.min.css" /><!-- Core Style Css -->
    <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/style.css" />

    <!-- Core Style Css -->
    <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/style-en.css" /> 
    <?php else: ?>
    <!-- bootstrap-rtl.min -->
    <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/bootstrap-rtl.min.css" />

  
    <!-- Core Style Css -->
    <link rel="stylesheet" href="<?php echo e(asset('/site')); ?>/css/style.css" />
    <?php endif; ?>



</head>

<body>




    <!-- =====================================
        ==== Start Navbar -->

    <nav class="navbar change navbar-expand-lg">
        <div class="container">

            <!-- Logo -->
            <a class="logo" href="#">
                <img src="<?php echo e(asset($branch->logo)); ?>" alt="logo">
            </a>

            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="icon-bar"><i class="fas fa-bars"></i></span>
            </button>

            <!-- navbar links -->
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav mr-auto rtl-row">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo e(url('/').'/'.@$branch->id.'/'.@$branch->translations->first()->name); ?>" data-scroll-nav="0"><?php echo app('translator')->getFromJson('home.home'); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#" data-scroll-nav="1"><?php echo app('translator')->getFromJson('home.about_us'); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link js-modal-show" href="#0" data-pop="pop1"><?php echo app('translator')->getFromJson('home.service_request'); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link js-modal-show" href="#0" data-pop="pop2"><?php echo app('translator')->getFromJson('home.contactus'); ?></a>
                    </li>
                    <li class="nav-item lang">
                        <a href="#0" class="nav-link"><i class="fas fa-globe"></i></a>
                        <ul class="menu">
                            <li><a href="#0">عربى</a></li>
                            <li><a href="#0">English</a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- End Navbar ====
        ======================================= -->


    <?php echo $__env->yieldContent('content'); ?>
   


    <!-- =====================================
        ==== Start Footer -->

    <footer class="bg-img" data-background="<?php echo e(asset('images/footer-bg.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <div class="item">
                        <!-- Logo -->
                        <a class="logo" href="#">
                            <img src="<?php echo e(@asset($branch->logo)); ?>" alt="<?php echo e(@$branch->translations->where('lang_id',$active_lang->id)->first()->title); ?>">
                        </a>

                        <div class="text">
                            <?php echo e(@$branch->translations->where('lang_id',$active_lang->id)->first()->content); ?>

                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="links">
                        <h5><?php echo app('translator')->getFromJson('home.important_url'); ?></h5>
                        <ul>
                            <li><i class="fas fa-angle-double-left"></i><span><a  data-scroll-nav="0"><?php echo app('translator')->getFromJson('home.home'); ?></a></span></li>
                            <li><i class="fas fa-angle-double-left"></i><span><a data-scroll-nav="1"><?php echo app('translator')->getFromJson('home.about_us'); ?></a></span></li>
                            
                            <li><i class="fas fa-angle-double-left"></i><span><a class=" js-modal-show" data-pop="pop2"><?php echo app('translator')->getFromJson('home.contactus'); ?></a></span></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="cont-info">
                        <h5><?php echo app('translator')->getFromJson('home.contact_info'); ?></h5>
                        <ul>
                            <li><i class="fas fa-phone-alt"></i><span><?php echo e(@$branch->phone); ?></span></li>

                            <li><i class="fas fa-envelope-open"></i><span><?php echo e(@$branch->email); ?></span></li>
                            <li><i class="fas fa-map-marked-alt"></i><span><?php echo e(@$branch->address); ?></span></li>
                        </ul>
                        <div class="social">
                            <?php $__currentLoopData = $setting->social_media_link; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chanel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($chanel->url); ?>" target="_blank"><img src="<?php echo e(@asset($chanel->icon)); ?>"></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- =====================================
        ==== Start order-services -->

    <div id="pop1" class="c-popup order-services">

        <h5>استماره طلب خدمه</h5>

        <div class="form">
           <form method="post" action="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/contactus')); ?>">
                       <?php echo csrf_field(); ?>

                <input type="hidden" name="status" value="get_service">
                <div class="form-group">
                      <input type="text" name="name" placeholder="<?php echo app('translator')->getFromJson('home.name'); ?>" value="<?php echo e(Request::old('name')); ?>">
                </div>
                <div class="form-group">
                     <input type="email" name="email" placeholder="<?php echo app('translator')->getFromJson('home.email'); ?>" value="<?php echo e(Request::old('email')); ?>">
                </div>
                <div class="form-group">
                    <input type="text" name="subject" placeholder="<?php echo app('translator')->getFromJson('home.subject'); ?>" value="<?php echo e(Request::old('subject')); ?>">
                </div>
                <div class="form-group">
                    <input type="text" name="phone" placeholder="<?php echo app('translator')->getFromJson('home.phone'); ?>" value="<?php echo e(Request::old('phone')); ?>">
                </div>
                <div class="form-group">
                     <textarea name="message" placeholder="<?php echo app('translator')->getFromJson('home.message'); ?>"><?php echo e(Request::old('message')); ?></textarea>
                </div>
                <button type="submit"><?php echo app('translator')->getFromJson('home.send'); ?></button>

            </form>
        </div>
    </div>
    <div id="pop2" class="c-popup contact">

        <div class="row">
            <div class="col-lg-7">
                <div class="form">
                    <h5><?php echo app('translator')->getFromJson('home.contactus'); ?></h5>
                    <form method="post" action="<?php echo e(url(LaravelLocalization::getCurrentLocale().'/contactus')); ?>">
                       <?php echo csrf_field(); ?>
                        <input type="hidden" name="status" value="contactus">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="name" placeholder="<?php echo app('translator')->getFromJson('home.name'); ?>" value="<?php echo e(Request::old('name')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                 <input type="email" name="email" placeholder="<?php echo app('translator')->getFromJson('home.email'); ?>" value="<?php echo e(Request::old('email')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                        <input type="text" name="subject" placeholder="<?php echo app('translator')->getFromJson('home.subject'); ?>" value="<?php echo e(Request::old('subject')); ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <input type="text" name="phone" placeholder="<?php echo app('translator')->getFromJson('home.phone'); ?>" value="<?php echo e(Request::old('phone')); ?>">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <textarea name="message" placeholder="<?php echo app('translator')->getFromJson('home.message'); ?>"><?php echo e(Request::old('message')); ?></textarea>
                                </div>
                            </div>
                        </div>
                        <button type="submit"><?php echo app('translator')->getFromJson('home.send'); ?></button>
                    </form>
                </div>
            </div>
            <div class="col-lg-4 offset-lg-1">
                <div class="cont-info">
                    <h5><?php echo app('translator')->getFromJson('home.contact_info'); ?></h5>
                    <ul>
                      <li><i class="fas fa-phone-alt"></i><span><?php echo e(@$branch->phone); ?></span></li>

                      <li><i class="fas fa-envelope-open"></i><span><?php echo e(@$branch->email); ?></span></li>
                      <li><i class="fas fa-map-marked-alt"></i><span><?php echo e(@$branch->address); ?></span></li>
                    </ul>
                    <div class="social">
                        <?php $__currentLoopData = $setting->social_media_link; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chanel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e($chanel->url); ?>" target="_blank"><img src="<?php echo e(@asset($chanel->icon)); ?>"></a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-shadow"></div>

    <!-- End order-services ====
        ======================================= -->


    <!-- End Footer ====
        ======================================= -->





    <!-- jQuery -->
    <script src="<?php echo e(asset('/site')); ?>/js/jquery-3.0.0.min.js"></script>
    <script src="<?php echo e(asset('/site')); ?>/js/jquery-migrate-3.0.0.min.js"></script>

    <!-- popper.min -->
    <script src="<?php echo e(asset('/site')); ?>/js/popper.min.js"></script>

    <!-- bootstrap -->
    <script src="<?php echo e(asset('/site')); ?>/js/bootstrap.min.js"></script>

    <!-- aos js -->
    <script src="<?php echo e(asset('/site')); ?>/js/wow.min.js"></script>

    <!-- scrollIt -->
    <script src="<?php echo e(asset('/site')); ?>/js/scrollIt.min.js"></script>

    <!-- slick carousel -->
    <script src="<?php echo e(asset('/site')); ?>/js/slick.min.js"></script>

    <!-- swiper.min js -->
    <script src="<?php echo e(asset('/site')); ?>/js/swiper.min.js"></script>

    <!-- YouTubePopUp.jquery -->
    <script src="<?php echo e(asset('/site')); ?>/js/YouTubePopUp.jquery.js"></script>

    <!-- validator js -->
    <script src="<?php echo e(asset('/site')); ?>/js/validator.js"></script>

    <!-- custom scripts -->
    <script src="<?php echo e(asset('/site')); ?>/js/scripts.js"></script>

    <!-- custom scripts -->
    <!-- <script src="<?php echo e(asset('/site')); ?>/js/scripts-en.js"></script> -->

    <script>
        new WOW().init();
    </script>

    <!-- Initialize Swiper -->
    <script>
        var swiper = new Swiper('.swiper-container', {
            effect: 'coverflow',
            grabCursor: true,
            centeredSlides: true,
            slidesPerView: 'auto',
            loop: true,
            coverflowEffect: {
                rotate: 50,
                stretch: 0,
                depth: 100,
                modifier: 1,
                slideShadows: true,
            },
            navigation: {
                nextEl: '.next',
                prevEl: '.prev',
            },
        });
    </script>



</body>

</html><?php /**PATH C:\xampp\htdocs\wahaj\resources\views/site/layouts/layout.blade.php ENDPATH**/ ?>