<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


	Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
	],
	function()
	{
		

	Route::group(['middleware' => 'auth'], function () {
	Route::group(['middleware' => 'admin'], function () {

		Route::group(['prefix' => '/admin'], function () {
		
			Route::get('setting','Admin\SettingController@create');
			Route::post('setting','Admin\SettingController@store');

			Route::get('home','Admin\HomeController@index');
			Route::get('reports_browsing','Admin\ReportsController@GetBrowsingInfo');
			Route::get('reports_browsing/{id}/u/{user_name}','Admin\ReportsController@getUserBrowseInfo');
			Route::get('reports_browsing/{id}/delete','Admin\ReportsController@delete_reports');

			Route::get('file/{id}/delete','Admin\SettingController@delete_external_file');

			Route::get('wating_lists','Admin\WatingListController@index');
			Route::get('wating_list/search','Admin\WatingListController@saarch');
			Route::get('wating_lists/export','Admin\WatingListController@ExportExelSheet');
			Route::get('wating_lists/{id}/delete','Admin\WatingListController@destroy');

			Route::resource('users','Admin\UsersController');
			Route::get('users_export','Admin\UsersController@ExportExelSheet');
			Route::get('users/{id}/delete','Admin\UsersController@destroy');
			Route::DELETE('users_delete_all','Admin\UsersController@destroyAll');
			

			Route::resource('sliders','Admin\SliderController');
			Route::get('sliders/{id}/delete','Admin\SliderController@destroy');
			Route::DELETE('sliders_delete_all','Admin\SliderController@destroySelected');

			Route::resource('branches','Admin\BranchesCntroller');
			Route::get('branches/{id}/delete','Admin\BranchesCntroller@destroy');
			Route::DELETE('branches_delete_all','Admin\BranchesCntroller@destroySelected');

			Route::resource('categories','Admin\CategoriesController');
			Route::get('categories/{id}/delete','Admin\CategoriesController@destroy');
			Route::get('categories_export','Admin\CategoriesController@ExportExelSheet');
			Route::DELETE('categories_delete_all','Admin\CategoriesController@destroyAll');
			Route::get('services_category/{category_id}/create','Admin\ServicesCategoryController@create');
			Route::post('services_category/{category_id}','Admin\ServicesCategoryController@store');
			Route::get('services_category/{category_id}','Admin\ServicesCategoryController@index');
			Route::get('services_category/{category_id}/edit','Admin\ServicesCategoryController@edit');
			Route::PUT('services_category/{category_id}',['uses'=>'Admin\ServicesCategoryController@update','as'=>'services_category.update']);


			Route::resource('testmonials','Admin\TestmonialsController');
			Route::get('testmonials/{id}/delete','Admin\TestmonialsController@destroy');
			Route::DELETE('testmonials_delete_all','Admin\TestmonialsController@destroyAll');
			Route::get('testmonials_export','Admin\TestmonialsController@ExportExelSheet');

			Route::resource('pages','Admin\PagesController');
			Route::get('pages/{id}/delete','Admin\PagesController@destroy');
			Route::DELETE('pages_delete_all','Admin\PagesController@destroyAll');


			Route::resource('ads','Admin\AdsController');
			Route::get('banned_ads','Admin\AdsController@bannedAds');
			Route::get('banned_ads/{ad_id}/{status}','Admin\AdsController@banneAdd');
			Route::get('ads/{id}/image/delete','Admin\AdsController@DestroyImage');
			Route::get('ads/{id}/delete','Admin\AdsController@destroy');
			Route::DELETE('ads_delete_all','Admin\AdsController@destroyAll');


			Route::get('aboutus/list','Admin\AboutusController@index');
			Route::get('aboutus','Admin\AboutusController@create');
			Route::get('aboutus/{id?}/edit','Admin\AboutusController@create');
			Route::post('aboutus','Admin\AboutusController@save');

			Route::resource('blogs','Admin\BlogsController');
			Route::get('blogs/{id}/delete','Admin\BlogsController@destroy');
			Route::get('blogs_search','Admin\BlogsController@search');			
			Route::get('blogs_export','Admin\BlogsController@ExportExelSheet');

			Route::get('service_request','Admin\ContactUsController@service_request');
			Route::get('contactus','Admin\ContactUsController@list');
			Route::get('contactus/{id}/delete','Admin\ContactUsController@destroy');
			Route::DELETE('contactus_delete_all','Admin\ContactUsController@destroyAll');
			Route::get('mail/reply/{contact_id}','Admin\ContactUsController@GetReply');
		    Route::post('contact_us/reply','Admin\ContactUsController@PostReply');

			Route::resource('countries','Admin\CountriesController');
			Route::get('countries/{id}/delete','Admin\CountriesController@destroy');
			Route::DELETE('countries_delete_all','Admin\CountriesController@destroySelected');

			Route::get('cities/{country_id}','Admin\CitiesController@index');
			Route::get('cities/{country_id}/create','Admin\CitiesController@create');
			Route::post('cities/{country_id}','Admin\CitiesController@store');
			Route::get('cities/{id}/delete','Admin\CitiesController@destroy');
			Route::DELETE('cities_delete_all','Admin\CitiesController@destroySelected');



			Route::get('places/{country_id}','Admin\PlacesController@index');
			Route::get('places/{country_id}/create','Admin\PlacesController@create');
			Route::post('places/{country_id}','Admin\PlacesController@store');
			Route::get('places/{id}/delete','Admin\PlacesController@destroy');
			Route::DELETE('places_delete_all','Admin\PlacesController@destroySelected');


			
			Route::resource('events','Admin\Eventsontroller');
			Route::get('events/{id}/delete','Admin\Eventsontroller@destroy');
			Route::DELETE('events_delete_all','Admin\Eventsontroller@destroySelected');

			Route::resource('groups','Admin\GroupsController');
			Route::get('groups/{id}/delete','Admin\GroupsController@destroy');
			Route::DELETE('groups_delete_all','Admin\GroupsController@destroySelected');
			
			Route::resource('reasons_reporting','Admin\ReasonsReportController');
			Route::get('reasons_reporting/{id}/delete','Admin\ReasonsReportController@destroy');
			Route::DELETE('reasons_reporting_delete_all','Admin\ReasonsReportController@destroySelected');

			Route::resource('notifications','Admin\NotificationsController');
    		Route::get('notifications/{id}/delete','Admin\NotificationsController@destroy');
			Route::DELETE('notifications_delete_all','Admin\NotificationsController@destroySelected');




			Route::get('sitemap/create','Admin\SitemapGeneratorController@create');
			Route::post('sitemap','Admin\SitemapGeneratorController@store');
		});


	});
	});
		Route::get('logout','Auth\LoginController@logout');
	});

	//site routes 
	

Route::get('/','Front\CoomingSoonController@index');
// Route::post('user/waiting','Front\WatingListController@setInList');

	Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
	],
	function()
	{
		Route::get('/','Front\HomeController@index');
		Route::get('/{id}/{title}','Front\HomeController@show');
		
		Route::post('contactus','Front\ContctUsController@posttSendAsk');

		
	

	Auth::routes();
	// Route::get('/register','Auth\CustomAuthController@Getsignup')->name('register');
	Route::get('/admin','Auth\CustomAuthController@adminLogin');
	});


