@extends('site.layouts.layout')
@section('content')
     @if ($errors->any())
        @foreach ($errors->all() as $error)
        <div class="alert alert-danger alert-dismissible" >
            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
        </div>
        @endforeach
        @endif
        @if(Session::has('success'))
        <div class="alert alert-success alert-dismissible">
            <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
        </div>
        @endif
     
 <!-- =====================================
        ==== Start slide -->

    <header id="home" class="header valign bg-img" data-scroll-index="0" data-background="{{ asset('/site/images/slider1.png') }}">

        <div class="container">
            <div class="row">
                <div class="col-lg-6 valign">
                    <div class="caption">
                        <h1>{{ @$slider->translations->where('lang_id',$active_lang->id)->first()->title }}</h1>
                        <div class="text">
                           {{ @$slider->translations->where('lang_id',$active_lang->id)->first()->content }}
                        </div>
                        <a href="#0" class="butn"><span>@lang('home.more')</span></a>
                    </div>
                </div>
                <div class="col-lg-6 valign">
                    <div class="img">
                        <img src="{{ asset($slider->img) }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- End slide ====
        ======================================= -->



    <!-- =====================================
        ==== Start about  -->
	@if($info != null)
    <section class="about-g section-padding bg-img" data-scroll-index="1" data-background="{{ asset('site/images/bg-pattern.png') }}">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2">
                    <div class="head text-center">
                        <h4>@lang('home.about_us')</h4>
                   
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="img">
                        <img src="{{ @asset($info->image )}}" alt="">
                    </div>
                </div>
                <div class="col-lg-6 valign">
                    <div class="content">
                        <h5>{{ $info->translations->where('lang_id',$active_lang->id)->first()->title }}</h5>
                        <div class="text">
                              {!! $info->translations->where('lang_id',$active_lang->id)->first()->content  !!}
                        </div>
                
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif


    <!-- End about  ====
        ======================================= -->



    <!-- =====================================
        ==== Start company -->

    <section class="company">
        <div class="container">
            <div class="row box">
                @foreach($branches as $list)
                <div class="col-lg-4 item">
                    <a href="{{ url(LaravelLocalization::getCurrentLocale()).'/'.@$list->id.'/'.str_replace(' ', '_',$list->translations->first()->name) }}">
                        <img src="{{asset('/')}}{{@$list->logo}}" alt="">
                        <h5>{{ $list->translations->first()->name }}</h5>
                    </a>
                </div>
                @endforeach

               {{--  <div class="col-lg-4 item">
                    <a href="#-">
                        <img src="images/1.jpg" alt="" class="big">
                        <h5 class="bold">شركة وهج الأعمال</h5>
                    </a>
                </div>
                <div class="col-lg-4 item nobord">
                    <a href="#0">
                        <img src="images/3.jpg" alt="">
                        <h5>قطاف لتجارة المواد الغذائية</h5>
                    </a>
                </div> --}}
            </div>
        </div>
    </section>

    <!-- End company ====
        ======================================= -->


    <!-- =====================================
        ==== Start company -->
    @if($products->count() > 0 )
    <section class="products petro section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2">
                    <div class="head text-center">
                        <h4>@lang('home.products')</h4>
                    {{--     <div class="text">
                            عند موافقه العميل المبدئيه على التصميم يتم ازالة هذا النص من التصميم ويتم وضع النصوص
                            النهائية المطلوبة للتصميم ويقول البعض ان وضع النصوص التجريبية.
                        </div> --}}
                    </div>
                </div>
            </div>
            <div class="slick">
                @foreach($products as $prodcut )
                <div class="item">
                    <a href="#0">
                        <img src="{{ @asset($prodcut->images->first()->image) }}" alt="">
                    	
                    </a>
                </div>
                @endforeach
              
            </div>
        </div>
    </section>
    @endif
    <!-- End company ====
        ======================================= -->



    <!-- =====================================
        ==== Start clients -->
	@if($parteners->count() > 0)
    <section class="clients section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 offset-lg-3 col-md-8 offset-md-2">
                    <div class="head text-center">
                        <h4>@lang('home.our_clients')</h4>
                      {{--   <div class="text">
                            عند موافقه العميل المبدئيه على التصميم يتم ازالة هذا النص من التصميم ويتم وضع النصوص
                            النهائية المطلوبة للتصميم ويقول البعض ان وضع النصوص التجريبية.
                        </div> --}}
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="slick">
                        @foreach($parteners as $partener)
                        <div class="item">
                            <a href="#0">
                                <div class="img"><img src="{{ asset($partener->image)}}" alt=""></div>
                            </a>
                        </div>
                        @endforeach
                     
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endif
    <!-- End clients ====
        ======================================= -->



    <!-- =====================================
        ==== Start subscribe -->

    <div class="subscribe">
        <div class="container">
            <div class="row">
                <div class="col-sm-4">
                    <div class="title">
                        <h5>اشترك الآن</h5>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="form">
                        <form action="">
                            <input type="email" name="subscribe" placeholder="البريد الإلكترونى">
                            <button type="submit">اشترك الآن</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- End subscribe ====
        ======================================= -->



@stop