@extends('panel.layouts.layout')
@section('content')
<!-- =====================================
 ==== Start Home-content  -->

 <section class="users-list">
     <div class="container-fluid">

         <div class="row">
             <div class="col-md-11">
                 <div class="wel-text">
                     <h6>@lang('home.contries_list')</h6>
                     <div class="path">
                         <a href="{{ url('admin/home') }}">@lang('home.home')</a>
                         <span>/</span> 
                         <a href="{{ url('admin/countries') }}">@lang('home.countries')</a>
                         <span>/</span> 
                         @lang('home.contries_list')
                     </div>
                 </div>
             </div>

             <div class="col-md-1">
                 <div class="dropdown">
                   <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
                       <span class="caret"></span></button>
                       <ul class="dropdown-menu" style="padding: 10px">
                         <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                         <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
                        

                     </ul>
                 </div>
             </div>
         </div>
         @if(Session('success'))
         <div class="alert alert-success alert-dismissible">
             <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
             <strong>@lang('home.success')!</strong> {{session('success')}}.
         </div>
         @endif
         <form action="{{ URL::to('/admin/cities_delete_all') }}" method="post">
        @csrf
        <input name="_method" type="hidden" value="DELETE">
         <div class="row" style="margin:5px;">
              <div class="col-md-2">
                  <button type="button" class="btn btn-info"  >
                  <input type="checkbox" id="select-all">
                  @lang('home.sellect_all')</button>
              </div>
              <div class="col-md-2">
                  <button type="button" class="btn btn-danger " data-toggle="modal" data-target="#DeleteSelected">
                     @lang('home.delete_all')
                  </button>

                  <!-- Modal -->
                  <div id="DeleteSelected" class="modal fade" role="dialog">
                          <div class="modal-dialog">
                            <!-- Modal content-->
                            <div class="modal-content">
                                  <div class="modal-header">
                                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                                      <h4 class="modal-title">@lang('home.header_delete_model')</h4>
                                  </div>
                                <div class="modal-body">
                                    <p>@lang('home.body_delete_all_model')</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">@lang('home.close')</button>
                                    <button type="submit"  class="btn btn-danger" >@lang('home.delete_all')</button>
                                </div>
                            </div>
                          </div>
                  </div>
              </div>
          </div>
         <table class="block-table" id="example" class="display" style="width:100%;margin10px">
           <thead>
             <tr>
                    <th>#</th>
                    <th>@lang('home.name')</th>
                    <th>@lang('home.delete')</th>
             </tr>
           </thead>
             <tbody>
                 @foreach($cities as $city)
                <tr>
                    <td><span class="text-semibold">
                            {{ @$city->id }}
                    <input type="checkbox" name="ids[]" value="{{ @$city->id }}"> 
                            
                    </span></td>
                    <td>
                        <span class="text-semibold">{{@$city->translation->name}} </span>
                   
                    </td>
                  
                   
                    <td>@include('panel.cities.delete_from_list')</td> 
                </tr>
                @endforeach
             </tbody>
         </table>
     </div>
 </section>
@stop
@section('jsCode')
    <script>
        // Listen for click on toggle checkbox
        $('#select-all').click(function(event) {   
            if(this.checked) {
                // Iterate each checkbox
                $(':checkbox').each(function() {
                    this.checked = true;                        
                });
            } else {
                $(':checkbox').each(function() {
                    this.checked = false;                       
                });
            }
        });
        $(document).ready(function() {
          $('#example').DataTable();
        });
    </script>
@stop