@extends('panel.layouts.layout')
@section('content')
<!-- =====================================
==== Start settings  -->
<br>
<section class="settings">
    <div class="container-fluid">
     <div class="row">
        <div class="col-md-11">
            <div class="wel-text">
                <div class="path">
                 <ul>
                    <a href="{{ url('admin/home') }}">@lang('home.home')</a>
                    <span>/</span>
                   <a href="{{ URL::to('admin/ads') }}"><i class="icon-home2 position-left"></i> @lang('home.products')</a>
                    <span>/</span>
                    @lang('home.create_products')
                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="dropdown">
          <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
              <span class="caret"></span></button>
              <ul class="dropdown-menu" style="padding: 10px">
               <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon ti-gear"></i>@lang('home.general_settings')</a></li>
                <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon ti-copy"></i> @lang('home.full_report')</a></li>
            </ul>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12 col-md-6">
        <div class="item">
            <div class="head">
                <h5> @lang('home.create_products')</h5>
            </div>
                     <form class="form-horizontal form-validate-jquery" method="POST" action="{{ URL::to('/admin/ads') }}" enctype='multipart/form-data'>
                                @if ($errors->any())
                                @foreach ($errors->all() as $error)
                                <div class="alert alert-danger alert-dismissible" >
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
                                </div>
                                @endforeach
                                @endif
                                @if(Session::has('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                                </div>
                                @endif
                                @csrf
                                @include('panel.ads.form')
                                <div class="text-right">
                                    <button type="submit" class="btn btn-primary">Submit <i class="icon-arrow-left13 position-right"></i></button>
                                </div>
                            </form>
        </div>
    </div>
    
</div>
</div>
</section>
@stop

@section('jsCode')
<script type="text/javascript">
// Full featured editor
// CKEDITOR.replace( 'editor1',{
//     extraPlugins: 'forms'
// });
// CKEDITOR.replace( 'editor2',{
//     extraPlugins: 'forms'
// });

//script getting sub categories fillter
$('#sub_categoris_unknown').hide()
$('#parent_id').on('change',function () {
    if ($(this).val() != '') {
        var parent_id = $(this).val();
        $.ajax({
            'url' : '{{ URL::to('/') }}/api/categories/' + parent_id,
            'type' : 'GET',
            'success' : function(data) {     
               console.log(data.data.length );
                if (data.data.length == 0) {
                    $('#sub_categoris').hide();
                    $('#sub_categoris_unknown').show();
                } //where sub categories list  length = 0
                else{//where sub categories list  length  > 0 will append in #sub_categoris

                    $('#sub_categoris').show();
                    $('#sub_categoris_unknown').hide();
                    $('#sub_categoris').empty()
                    for (var i = data.data.length - 1; i >= 0; i--) {
                        $('#sub_categoris').append("<option value='"+data.data[i].id+"'>"+data.data[i].category_translation.name+"</option")   
                    }
                    
                }   
            }//server success case 
            ,'error' : function(request,error)
            {
                $('#sub_categoris').hide();
                $('#sub_categoris_unknown').show();
            }//server error case 
        });
    }else{
        $('#sub_categoris').hide();
        $('#sub_categoris_unknown').show();
    }
});
</script>
@stop