@extends('panel.layouts.layout')
@section('content')
<!-- =====================================
==== Start settings  -->
<br>
<section class="settings">
    <div class="container-fluid">
     <div class="row">
        <div class="col-md-11">
            <div class="wel-text">
                <div class="path">
                 <ul>
                    <a href="{{ URL::to('/admin/home') }}"><i class="icon-home2 position-left"></i> @lang('home.home')</a>
                    <span>/</span>
                    @lang('home.about_us') @lang('home.update')

                </ul>
            </div>
        </div>
    </div>

    <div class="col-md-1">
        <div class="dropdown">
          <button class="btn btn-defualt dropdown-toggle" type="button" data-toggle="dropdown">@lang('home.links')
              <span class="caret"></span></button>
              <ul class="dropdown-menu" style="padding: 10px">
                <li  style="padding: 10px"><a href="{{ URL::to('ar/admin/setting') }}"><i class="icon-gear"></i>@lang('home.general_settings')</a></li>
                <li  style="padding: 5px"><a href="{{ URL::to('ar/admin/reports_browsing') }}"><i class="icon-copy"></i> @lang('home.full_report')</a></li>
            </ul>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-10 col-md-6">
        <div class="item">
            <div class="head">
                <h5> @lang('home.update_info')</h5>
            </div>
             <form class="form-horizontal form-validate-jquery" method="POST" action="{{ URL::to(LaravelLocalization::getCurrentLocale().'/admin/aboutus') }}" enctype='multipart/form-data'>
                                @if ($errors->any())
                                @foreach ($errors->all() as $error)
                                <div class="alert alert-danger alert-dismissible" >
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{@$error }}
                                </div>
                                @endforeach
                                @endif
                                @if(Session::has('success'))
                                <div class="alert alert-success alert-dismissible">
                                    <a href="#" class="close" data-dismiss="alert" aria-label="close" style="right: 5px;">&times;</a>{{ Session::get('success') }}
                                </div>
                                @endif
                                @csrf
                                       {{-- general Info --}}
                        <fieldset class="content-group">
                        <!-- choose category input -->
                        <div class="form-group" >
                            <label class="control-label col-lg-3">@lang('home.branches') <span class="text-danger" title="@lang('home.required')">*</span></label>
                            <div class="col-lg-12"> 
                                <select name="branch_id" class="form-control" >
                                    <option value="">@lang('home.select_one')</option>
                                    @foreach($branches as $branch)
                                    <option value="{{@$branch->id}}" @if(@$info->branch_id == $branch->id) selected @endif>
                                        {{@$branch->translations->first()->name}}

                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                                    @if($site_langs->count() > 0)
                                    @foreach($site_langs as $key => $lang)

                                    <input type="hidden" name="lang[]" value="{{ @$lang->id }}">

                                    <!-- title ar input -->
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.title_'.@$lang->info->local) <span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                            <input type="text" name="title[]" class="form-control" placeholder="@lang('home.title_'.@$lang->info->local)" value="@if($info != null) {{ @$info->translations->where('lang_id',$lang->id)->first()->title }} @endif">
                                        </div>
                                    </div>
                                    <!-- /title ar input -->
                                    {{-- mission ar --}}
                                     <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.content_'.@$lang->info->local) <span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                             <textarea name="content[]" class="form-control" rows="4" id="example{{ @$key }}" cols="4"  placeholder="@lang('home.content_'.@$lang->info->local)">@if($info != null) {{ @$info->translations->where('lang_id',$lang->id)->first()->content }} @endif</textarea>
                                        </div>
                                    </div>
                                    {{-- mission ar --}} 
                                    {{-- mission ar --}}
                                {{--      <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.mission') {{ @$lang->info->local }}<span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                             <textarea name="mission[]" class="form-control" rows="4" cols="4"  placeholder="@lang('home.mission_'.@$lang->info->local)">@if($info != null) {{ @$info->translations->where('lang_id',$lang->id)->first()->mission }} @endif</textarea>
                                        </div>
                                    </div> --}}
                                    {{-- mission ar --}} 

                                     {{-- mission ar --}}
                                     {{-- <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.goals')  {{ $lang->info->local}}<span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                             <textarea name="goals[]" class="form-control" rows="4" cols="4"  placeholder="@lang('home.goals') {{ $lang->info->local}}">@if($info != null) {{ @$info->translations->where('lang_id',$lang->id)->first()->goals }} @endif</textarea>
                                        </div>
                                    </div> --}}
                                    {{-- mission ar --}} 

                                     {{-- who we are working --}}
                                     {{-- <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.who_we_are_working') {{ @$lang->info->local }} <span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                             <textarea name="who_we_are_working[]" class="form-control" rows="4" cols="4"  placeholder="@lang('home.who_we_are_working '.@$lang->info->local)">@if($info != null) {{ @$info->translations->where('lang_id',$lang->id)->first()->who_we_are_working }} @endif</textarea>
                                        </div>
                                    </div> --}}
                                    {{-- mission ar --}} 

                                    @endforeach 
                                    @endif
                                    <!-- url page input -->
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.vedio_url') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                            <input type="text" name="vedio_url" class="form-control"  placeholder="@lang('home.vedio_url')" value="{{@$info->vedio_url}}">
                                        </div>
                                    </div>
                                    <!-- /url page input -->

                                    <!-- Meta Tags input -->
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.meta_tags') <span class="text-danger" title="@lang('home.required')">*</span></label>
                                        <div class="col-lg-12">
                                            <input type="text" name="meta_tags" class="form-control tokenfield" placeholder="@lang('home.placeholder_metatags')" value="{{@$info->meta_tags}}">
                                        </div>
                                    </div>
                                    <!-- /Meta Tags input -->
                                                                        
                                    <!-- Logo uploader -->
                                    <div class="form-group">
                                        <label class="control-label col-lg-3">@lang('home.image') <span class="text-danger" title="@lang('home.required')"> *</span></label>
                                        <div class="col-lg-12">
                                            <input type="file" name="image" class="file-styled" >
                                        </div>
                                    </div>
                                    <!-- /Logo uploader -->
                                 
                                </fieldset>
                                {{-- general Info --}}
                              
                           

                <button type="submit" class="btn btn-primary">@lang('home.save') <i class="icon-arrow-left13 position-right"></i></button>

            </form>
        </div>
    </div>
    <div class="col-md-2">
         <img src="{{url('/').@$info->image}}" class="img-responsive" style="max-width:100%" >
    </div>
    
</div>
</div>
</section>

@stop
@section('jsCode')
<script type="text/javascript">
    var textarea1 = document.getElementById('example0');
    var textarea2 = document.getElementById('example1');
        CKEDITOR.replace( textarea1 );
        CKEDITOR.replace( textarea2 );
</script>
@stop