<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateNotificationTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('notification', function (Blueprint $table) {

            $table->bigIncrements('id');

          

            $table->unsignedBigInteger('sender_id')->nullable();

            $table->foreign('sender_id')->references('id')->on('users')->onDelete('cascade');

            $table->string('title');

            $table->string('msg');

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('notification');

    }

}

