<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreatePlaceTranslationsTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('place_translations', function (Blueprint $table) {

            $table->bigIncrements('id');

            $table->unsignedBigInteger('place_id');

            $table->foreign('place_id')->references('id')->on('places')->onDelete('cascade');

            $table->unsignedInteger('lang_id');

            $table->foreign('lang_id')->references('id')->on('setting_langs')->onDelete('cascade');

            $table->string('name');

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('place_translations');

    }

}

