<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateWaitingListsTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('waiting_lists_users', function (Blueprint $table) {

            $table->increments('id');

            $table->string('name')->nullable();

            $table->string('email')->nullable();

            $table->string('phone')->nullable();

            $table->unsignedInteger('address');

            $table->foreign('address')->references('id')->on('cities')->onDelete('cascade');

            $table->enum('status',['not_read','read','other']);

            $table->enum('type',['user','company','other']);

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('waiting_lists_users');

    }

}

