<?php



use Illuminate\Support\Facades\Schema;

use Illuminate\Database\Schema\Blueprint;

use Illuminate\Database\Migrations\Migration;



class CreateSettingPhonesTable extends Migration

{

    /**

     * Run the migrations.

     *

     * @return void

     */

    public function up()

    {

        Schema::create('setting_phones', function (Blueprint $table) {

            $table->increments('id');

            $table->unsignedInteger('setting_id');

            $table->foreign('setting_id')->references('id')->on('settings')->onDelete('cascade');

            $table->string('phone')->nullable();

            $table->softDeletes();

            $table->timestamps();

        });

    }



    /**

     * Reverse the migrations.

     *

     * @return void

     */

    public function down()

    {

        Schema::dropIfExists('setting_phones');

    }

}

