<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;

class UserInfoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id'=>$this->id,
            'fname'=>$this->fname,
            'lname'=>$this->lname,
            'email'=>$this->email,
            'phone'=>$this->phone,
            'image'=>asset($this->image),

            'country'=>($this->country != null) ? [
                'id'=>$this->country->id,
                'name'=>$this->country->translations->first()->name
            ]:[] ,
        
        ];
    }
}
