<?php

namespace App\Http\Resources\Api;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\AdsResource;

class HomeResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'=>$this->id,
            'icon'=>asset($this->icon),
            'name'=>$this->translations->first()->name,
            'ads'=>AdsResource::collection($this->ads->take(10))
        ];
    }
}
