<?php

namespace App\Http\Controllers\Front\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Groups,App\GroupsTranslation;
use App\User,App\GroupMembers;
use App\Http\Requests\Front\GroupRequest;
use App\Http\Controllers\ImagesController;
use Auth;
use Session;

class GroupsController extends Controller
{
    public $view = 'front.user.groups.';

    public function __construct(
			Groups $model,
			GroupsTranslation $translation,
			GroupMembers $member
		)
	{
        $this->model = $model;
        $this->translation = $translation;
        $this->member = $member;
	}

	public function index()
	{
		$groups = $this->model->where('user_id',Auth::id())->get();
		return view($this->view.'index',compact('groups'));
	}

	public function create()
	{
		$users = User::where('type_user','user')->get();
		return view($this->view.'create',compact('users'));
	}

	public function store(GroupRequest $request)
	{
		if ($request->hasFile('icon')) {
			$file = $request->file('icon');
    		$path = public_path().'/uploads/images/groups/'.date('o-m-d');
    		$db_path = '/uploads/images/groups/'.date('o-m-d');
    		$img = ImagesController::uploadSingle($file,$path,$db_path);
		}else{
			$img = '/img/unknown.png';
		}
		$insert =  $this->model->create([
		'user_id'=>Auth::id(),
    	'adv_id'=>NULL,
    	'type'=>$request->privacy,
    	'image'=>$img,
		]);

    	foreach ($request->lang as $key => $lang) {
			$translations = $this->translation->create([
									'lang_id'=>$lang,
									'group_id'=>$insert->id,
									'name'=>$request->name[$key],
							]);
		}

			if ($request->has('members')) {
			foreach ($request->members as $key_memeber => $member) {
				$this->member->create([
					'user_id'=>$member,
	    			'group_id'=>$insert->id,
				]);
			}
		}

		Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

}
