<?php

namespace App\Http\Controllers\Front;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Slider,App\Pages,App\Branches;
use App\Ads;
use App\Aboutus;
use App\TestMonials;
class HomeController extends Controller
{
    public function index()
    {
        $branches = Branches::with('translations')->get();
    	return view('site.index',compact('branches'));
    }

    public function show($branch_id,$name)
    {
        $branch = Branches::find($branch_id);
        $branches = Branches::with('translations')->get();

        $slider = Slider::where('branch_id',$branch_id)->with('translations')->first();
        $parteners = TestMonials::where('branch_id',$branch_id)->get();
        $info = Aboutus::where('branch_id',$branch_id)->first();
        $products = Ads::where('branch_id',$branch_id)->with('images')->get();
        // dd($products);
        return view('site.site',compact('branch','info','slider','branches','parteners','products'));
    }
    public function contact()
    {
    	return view('front.contact_us');
    }

    public function about_us()
    {
        return view('front.about_us');
    }

    public function page($id,$url= null)
    {
        $page = Pages::find($id);
    	return view('front.pages.show',compact('page'));
    }
}
