<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\PageResource;
use App\Http\Resources\Api\AboutUsResource;
use App\Http\Resources\Api\CompanyInfoResource;
use App\Pages,App\Aboutus,App\Setting,App\Category;
use Response;
class PagesController extends Controller
{
    
    public function pages()
    {
    	$pages  = PageResource::collection(Pages::where('url','!=','policy')->get());
    	if ($pages->count() > 0 ) {
    	$msg = "جميع الصفحات ";
    	}else{
    		$msg = 'لم يتم اضافة صفحات حتي الآن';
    	}
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$pages
                ];   
        return Response::json($response,200) ; 
    }

    public function regester_policy()
    {
    	$pages  =new PageResource(Pages::where('url','policy')->first());
    	$msg = "شروط التسجيل في التطبق";
    	$response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$pages
                ];   
        return Response::json($response,200) ; 
    }

    public function Aboutus()
    {
        $about_us = new AboutUsResource(Aboutus::first());
        // $categories_has_ads = Category::whereHas('ads')->with('ads','ads.images')->get();

        $msg = "من نحن";
        $response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$about_us,
                    // 'categories_has_ads'=>$categories_has_ads
                ];   
        return Response::json($response,200) ; 
    }

    public function comanyInfo()
    {
        $base_info = new CompanyInfoResource(Setting::first());
        $msg = "بيانات الاتصال ";
        $response = [
                    'success'=>TRUE,
                    'message'=>$msg,
                    'data'=>$base_info
                ];   
        return Response::json($response,200) ; 
    }
   
}
