<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Place,App\PlaceTranslation;
use Jenssegers\Agent\Agent;
use App\Http\Requests\Admin\CountriesRequest;
use App\Helpers\DoFire;
use Session;
use Auth;

class PlacesController extends Controller
{

	public $view = 'panel.places.';
    public function __construct(Place $place,PlaceTranslation $translation)
	{
        $this->place = $place;
        $this->translation = $translation;
	}

	public function index($country_id,Request $request)
    {
    	$places = $this->place->where('country_id',$country_id)->with('translation')->get();
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_countries','text'=>'List All Countries','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('places'));
    }

   	public function create(Request $request,$place_id)
    {
    	$place_id = $place_id;
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_place_view','text'=>'Create New place View','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'create',compact('place_id'));
    }


    public function store(CountriesRequest $request,$country_id)
    {
    	$create = $this->place->create([
    		'country_id'=>$country_id
    	]);
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'lang_id'=>$lang,
	    		'place_id'=>$create->id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_place','text'=>'Create New place','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

 	public function destroy($id,Request $request)
    {
    	$this->place->destroy($id);
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_place','text'=>'Delete place','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }
    public function destroySelected(Request $request)
    {
    	$this->place->whereIn('id',$request->ids)->delete();
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_places','text'=>'Delete places','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }    

}
