<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CountriesRequest;
use App\ServicesCategoryTranslations;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\ServicesCategory;
use App\County,App\ContryTranslation;
use Auth;
use Session;

class CountriesController extends Controller
{
	public $view = 'panel.countries.';
    
    public function __construct(County $countries,ContryTranslation $translation)
	{
        $this->countries = $countries;
        $this->translation = $translation;
	}

	public function index(Request $request)
    {
    	$countries = $this->countries->all();
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_list_countries','text'=>'List All Countries','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'index',compact('countries'));
    }

   	public function create(Request $request)
    {
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_country_view','text'=>'Create_New_Country View','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'create');
    }


    public function store(CountriesRequest $request)
    {
    	$create = $this->countries->create($request->except('_token','lang','name','ipinfo'));
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'lang_id'=>$lang,
	    		'country_id'=>$create->id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_create_new_country','text'=>'Create New Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

    public function edit($id,Request $request)
    {
    	$country  = $this->countries->find($id);
    	$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_edit_country_view_id:'.$id,'text'=>'dashboard edit country view ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
    	return view($this->view.'edit',compact('country'));
    }


    public function update(CountriesRequest $request,$id)
    {
    	$create = $this->countries->find($id)->update($request->except('_token','lang','name','ipinfo','_method'));
    		$this->translation->where('country_id',$id)->delete();
    	foreach ($request->lang as $key => $lang) {
	    	$translation = $this->translation->create([
	    		'name'=>$request->name[$key],
	    		'lang_id'=>$lang,
	    		'country_id'=>$id
	    	]);
    	}

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_country_id:'.$id,'text'=>'update Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

    public function destroy($id,Request $request)
    {
    	$this->countries->where('id',$id)->delete();

    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_update_country_id:'.$id,'text'=>'update Country','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }


    public function destroySelected(Request $request)
    {
    	$this->countries->whereIn('id',$request->ids)->delete();
    	$agent = new Agent();
    	$agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_countres:','text'=>'Delte Countries','browser'=>$agent];
        session::flash('success',trans('home.message_success'));
    	return redirect()->back();
    }

}
