<?php
/*
*********************************
* Name: Amr Muhamed             *
* Email: amrmuhamed9@gmail.com  *
* Phone: +201061637022          *
* Copywrits @amrMU Githup       *
* *******************************
*/
namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\MailReplyRequest;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\Notifications\Admin\ContactUsNotify;
use App\ContctUs;
use Notification;
use Session;
use Auth;
use Mail;

class ContactUsController extends Controller
{
	 public $view = 'panel.contactus.';
    
    public function __construct(ContctUs $contact)
	{
        $this->contact = $contact;
	}

    public function service_request(Request $request)
    {
        $lists = $this->contact->where('status','get_service')->get();
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_contact_us','text'=>'Browse contact_us ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$lists,$request->ipinfo);
        return view($this->view.'index',compact('lists'));
    }


    public function list(Request $request)
    {
    	$lists = $this->contact->where('status','contactus')->get();
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_browse_contact_us','text'=>'Browse contact_us ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$lists,$request->ipinfo);
    	return view($this->view.'index',compact('lists'));
    }

    public function destroy($id,Request $request)
    {
        $agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_delete_contact_us_id_'.$id,'text'=>'delete contact_us ','browser'=>$agent];
        $info = $this->contact->find($id);
        DoFire::MK_REPORT($data,Auth::id(),$info,$request->ipinfo);
        $this->contact->destroy($id);
        session::flash('success',trans('home.message_success'));
        return redirect()->back();
    }

     public function destroyAll(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_contact_us_['.json_encode($request->ids).']','text'=>'Destroy selected Contact Us Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->contact->wherein('id',$request->ids)->delete();
        }else{
        $this->contact->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


    public function GetReply($id)
    {
        $contact =  $this->contact->find($id);
      $this->contact->find($id)->update(['read'=>'1']);

        return view($this->view.'reply',compact('contact'));
    }

    public function PostReply(MailReplyRequest $request)
    {
        $id = $request->get('id');
        $subject = $request->get('subject');
        $email = $request->get('email');
        $moreUsers = $request->get('moreUsers');
        $evenMoreUsers = $request->get('evenMoreUsers');
        $mms = $request->get('message');
        $this->contact->find($id)->update(['reply'=>'1']);
        $contact = $this->contact->find($id);
        
        $notify =   Notification::send(
                        $contact,
                        new ContactUsNotify($request->all())
                    );
        
        $message_success = Session::flash('success','تم إرسال الرد للمستخدم');
        return redirect()->back();
    }
}
