<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Jenssegers\Agent\Agent;
use App\Helpers\DoFire;
use App\Branches,App\BranchesTranslations;
use Session;
use Auth;
class BranchesCntroller extends Controller
{
	 public $view = 'panel.branches.';

    public function __construct(
			Branches $branch,
			BranchesTranslations $translation
			
		)
	{
        $this->branch = $branch;
        $this->translation = $translation;
	}


	/*
	*
	* 	Getting Edit Ads View
	*	@return view with data
	*	@method GET
	*
	**/
	public function index(Request $request)
	{
		$branches= $this->branch->with('translations')->get(); 
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_List_Branch','text'=>'List New Branch  ','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

		return view($this->view.'index',compact('branches'));
	}

	
	public function create(Request $request)
	{
		$branch = [];
       
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_show_Create_Ad','text'=>'Show Create New Add  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);
        
		return view($this->view.'create',compact('branch'));
	}

	public function store(Request $request)
	{

        if($request->hasFile('icon')){
            $file =$request->file('icon');
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/branches', $fullname);
            $path ='/uploads/images/branches';
            $image = $path.'/'.$fullname;
        }else{
			$image=  'img/unknown.png' ;    	
        }
	
		$create = $this->branch->create([
						'phone'=>$request->phone,
						'email'=>$request->email,
						'address'=>$request->address,
						'logo'=>$image
					]);//end save base info

		if ($request->has('lang')) {
			$translation = [];
			foreach ($request->lang as $key => $lang) {
			$translation =	$this->translation->create([
									'branch_id'=>$create->id,
									'lang_id'=>$lang,
									'name'=>$request->name[$key],
									'content'=>$request->content[$key],
								]);
			}//end loop save translation
		}//end languages when we lave lang

		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Store_New_Branch','text'=>'Store New Branch  ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$create,$request->ipinfo);
        Session::flash('success',trans('home.message_success'));

		return redirect()->back();
	}

	/*
	*
	* 	Getting Edit Ads View
	*	@return view with data
	*	@method GET
	*
	**/
	public function edit($id,Request $request)
	{
		$branch= $this->branch->find($id); 
		
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_edit_branch_id_'.$id,'text'=>'Show edit New branch','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$branch,$request->ipinfo);
		return view($this->view.'edit',compact('branch'));
	}

	public function update($id,Request $request)
	{		
		if($request->hasFile('icon')){
            $file =$request->file('icon');
			$time = time();
			$ext = $file->getClientOriginalExtension();
			$fullname = $time . '.' . $ext;
            $move = $file->move(public_path() .'/uploads/images/branches', $fullname);
            $path ='/uploads/images/branches';
            $image = $path.'/'.$fullname;
        }else{
        	$image = $this->branch->find($id)->logo;
        }
		$update  = $this->branch->find($id)->update([
						'phone'=>$request->phone,
						'email'=>$request->email,
						'address'=>$request->address,
						'logo'=>$image
					]);//end save base info

		if ($request->has('lang')) {

			$this->translation->where('branch_id',$id)->delete();
			$translation = [];
			foreach ($request->lang as $key => $lang) {
			$translation =	$this->translation->create([
									'branch_id'=>$id,
									'lang_id'=>$lang,
									'name'=>$request->name[$key],
									'content'=>$request->content[$key],
								]);
			}//end loop save translation
		}//end languages when we lave lang

		

		// dd($request->images,$set_images_path_db);
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboard_Store_New_Branch','text'=>'Update Branch Info ','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->branch->find($id),$request->ipinfo);
        Session::flash('success',trans('home.message_success'));

		return redirect()->back();
	}




	public function Destroy($id,Request $request)
	{
		$this->branch->where('id',$id)->delete();
		$agent = new Agent();
        $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
        $data = ['key'=>'dashboar_remove_branch_image','text'=>'Remove Branch Image','browser'=>$agent];
        DoFire::MK_REPORT($data,Auth::id(),$this->branch->find($id),$request->ipinfo);
        Session::flash('success',trans('home.message_success'));
		return redirect()->back();
	}

	public function destroySelected(Request $request)
    {

       $agent = new Agent();
       $agent = $agent->platform().','.$agent->browser().$agent->version($agent->browser());
       $data = ['key'=>'dashboard_destroy_branch_ids_['.json_encode($request->ids).']','text'=>'Destroy selected ad Info','browser'=>$agent];

        DoFire::MK_REPORT($data,Auth::id(),null,$request->ipinfo);

        if ($request->has('ids')) {
            $this->branch->wherein('id',$request->ids)->delete();
        }else{
        $this->branch->truncate();
        }
        Session::flash('success',trans('home.message_success'));
        return redirect()->back();  
    }


}
