<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Branches extends Model
{
    protected $table = "branches";
    protected $fillable = [
    	'phone',
		'email',
		'address',
		'logo',
    ];

    public function translations()
    {
    	return $this->hasMany('App\BranchesTranslations','branch_id','id');
    }

    public function translation()
    {
    	return $this->belongsTo('App\BranchesTranslations','branch_id','id');
    }
}
